<?php
session_start();
if (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
    header('Location: /menu-admin/');
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = $_POST['username'] ?? '';
    $pass = $_POST['password'] ?? '';

    $users = json_decode(file_get_contents(__DIR__ . '/users.json'), true);

    if (isset($users[$user]) && password_verify($pass, $users[$user])) {
        $_SESSION['logged_in'] = true;
        $_SESSION['username'] = $user;

        if (!empty($_POST['remember'])) {
            setcookie('remember', $user, time() + (86400 * 7), "/");
        }

        header('Location: /menu-admin/');
        exit;
    } else {
        $error = 'Emri ose passwordi eshte gabim!';
    }
}
?>
<!DOCTYPE html>
<html lang="sq">
<head>
  <meta charset="UTF-8">
  <title>Admin Login</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background: linear-gradient(135deg, #0d47a1, #1976d2);
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      color: white;
    }

    .login-box {
      background: #fff;
      color: #333;
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 8px 20px rgba(0,0,0,0.2);
      width: 100%;
      max-width: 360px;
    }

    .login-box h2 {
      margin-bottom: 20px;
      text-align: center;
      font-weight: 600;
    }

    .login-box input[type="text"],
    .login-box input[type="password"] {
      width: 100%;
      padding: 10px;
      margin-bottom: 15px;
      border: 1px solid #ccc;
      border-radius: 6px;
      font-size: 14px;
    }

    .login-box button {
      width: 100%;
      background: #0d47a1;
      color: white;
      border: none;
      padding: 12px;
      font-size: 16px;
      border-radius: 6px;
      cursor: pointer;
      transition: background 0.3s;
    }

    .login-box button:hover {
      background: #08306b;
    }

    .login-box label {
      font-size: 14px;
    }
  </style>
</head>
<body>
  <div class="login-box">
    <h2>Admin Login</h2>
    <form method="post">
      <input type="text" name="username" placeholder="Perdoruesi" required><br>
      <input type="password" name="password" placeholder="Passwordi" required><br>
      <label><input type="checkbox" name="remember" value="1">Me mbaj mend</label><br><br>
      <button type="submit">Hyr</button>
      <?php if ($error): ?><p style="color:red;"><?= $error ?></p><?php endif; ?>
    </form>
  </div>
</body>
</html>
