file_put_contents(__DIR__ . '/error.log', "Saving to: $filename\n", FILE_APPEND);
file_put_contents(__DIR__ . '/error.log', "Payload: " . print_r($_POST, true) . "\n", FILE_APPEND);

<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

if (!$data || !isset($data['id']) || !isset($data['menu'])) {
    http_response_code(400);
    file_put_contents(__DIR__ . '/error.log', "❌ Invalid request or bad JSON:\n$raw\n", FILE_APPEND);
    echo "Invalid request";
    exit;
}

$restaurantId = preg_replace('/[^a-zA-Z0-9_-]/', '', $data['id']);
$menu = $data['menu'];
$path = __DIR__ . "/menus/{$restaurantId}.json";

if (file_put_contents($path, json_encode($menu, JSON_PRETTY_PRINT))) {
    echo "Saved";
} else {
    http_response_code(500);
    file_put_contents(__DIR__ . '/error.log', "❌ Failed to write to $path\n", FILE_APPEND);
    echo "Failed to save";
}
?>
