<?php
// menu-admin/save-menu.php

$data = json_decode(file_get_contents('php://input'), true);
if (!$data || !isset($data['id']) || !isset($data['menu'])) {
  http_response_code(400);
  echo "Invalid data.";
  exit;
}

$id = basename($data['id']);
$filePath = __DIR__ . "/menus/$id.json";

// Ensure directory exists
if (!is_dir(__DIR__ . "/menus")) {
  mkdir(__DIR__ . "/menus", 0777, true);
}

// Attempt to save JSON
$json = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
if (file_put_contents($filePath, $json)) {
  http_response_code(200);
  echo "OK";
} else {
  http_response_code(500);
  echo "Save failed.";
}
